class Respawnables_PRI extends PlayerReplicationInfo;

var string 	Rank;			//Rank string of the current rank the player has based on XP
var int		XP;				//The expirience level of the player
var int		Money;			//The players current amount of money
var int		NumFragged;		//The number of players fragged within current spree, resets when dead
var int		MaxSpree;		//Holds the info about the players longest spree
var string	WeaponString;	//Holds info about what weapons has been purchased
var string	InventoryString;//Holds info about what inventory has been purcahsed
var int		TimePlayed;		//Holds the total seconds the player has been playing
var float	MaxHealth;		//Holds the info for the players max health
var bool	bShopping;		//True if player is shopping
var bool	bHasTornado;	//True if player is wearing Tornado pickup
var bool	bHasShield;		//True if player is wearing Shield pickup
var bool	bHasDoubleDamage;//True if player is wearing Double Damage pickup
var bool	bHasHealthRegrow;//True if player is wearing Health Regrow pickup
var bool	bHasRadar;		//True if player has purchased radar gear
var bool	bRadarMutatedOff;//True if player has used mutate command to turn of, used to not show radar when player dies and respawns(ModifyPlayer).
var string	Category;		//Holds the category the owner is currently viewing
var int		NumInCategory;	//Holds the number of the item of the category the owner is currently viewing
var int		NumItems;		//Holds the number of inventory item to draw on HUD (Pickups)
var string	RespawnablesID; //Holds the players ID key used to identify player in the statistics
var bool	bAddedToTempDB;	//True when player is added to mutater class database
var bool	bSynced;		//True when player has finished recieving info from server and are ready to shop
var bool	bStarted;		//True if player has closed shop menu
var bool	bJumpBoots;		//Toggles jumpboots on/off

//Menu variables:
var string	Viewing;		//Holds info about what page the player is currently viewing in the menu (shop), default = "home"
var int		ViewItem;		//Holds info about what item is currently selected, default = 0
var int		MenuCountdown;	//Controls the time available for the player to browse the menu, auto start player when countdown is done

replication
{
	// Things the server should send to the client.
	reliable if (Role == ROLE_Authority)
		Rank,XP,Money,NumFragged,MaxSpree,WeaponString,InventoryString,MaxHealth,bShopping,bHasTornado,bHasShield,bHasDoubleDamage,bHasRadar,bRadarMutatedOff,
		bHasHealthRegrow,Category,NumInCategory,NumItems,RespawnablesID,Viewing,ViewItem,bAddedToTempDB,bSynced,bStarted,bJumpBoots,MenuCountdown;
}

function PreBeginPlay()
{
	Super.PreBeginPlay();
	SetTimer(1.0,True);
}

function PostBeginPlay()
{
	StartTime = Level.TimeSeconds;
	bIsFemale = Pawn(Owner).bIsFemale;
}

function Timer()
{
local int TempItems;

	//Super.Timer();
	
	//Detect if player is playing (not shopping or iddle) and increment TimePlayed
	if ( !bWaitingPlayer && !bIsSpectator)
		TimePlayed += 1;
	
	//Update Rank according to XP:
	if ( XP < 1000 )
		Rank = "Private";
	else if ( XP < 2000 )
		Rank = "Corporal";
	else if ( XP < 3000 )
		Rank = "Sergeant";
	else if ( XP < 4000 )
		Rank = "Officer";
	else if ( XP < 5000 )
		Rank = "Lieutenant";
	else if ( XP < 6000 )
		Rank = "Captain";
	else if ( XP < 7000 )
		Rank = "Major";
	else if ( XP < 8000 )
		Rank = "Colonel";
	else if ( XP < 9000 )
		Rank = "Brigadier";
	else if ( XP < 10000 )
		Rank = "General";
	else
		Rank = "Marshal";
		
	//Update NumItems:
	if ( bHasTornado )
		TempItems++;
	if ( bHasShield )
		TempItems++;
	if ( bHasDoubleDamage )
		TempItems++;
	NumItems = TempItems;
	
	//Detect if menu countdown time has run out, then start player if player is synced:
	if ( !bStarted )
		{
		if ( MenuCountdown <= 0 )
			{
			if ( bSynced )
				{
				bStarted = True;
				}
			}
		else if ( MenuCountdown < 11 )
			{
			PlayerPawn(Owner).ClientPlaySound(Sound'BotPack.ChatSound.NewBeep', , true);
			MenuCountdown--;
			}
		else
			MenuCountdown--;
		}
		
	if (PlayerPawn(Owner) != None)
		Ping = int(PlayerPawn(Owner).ConsoleCommand("GETPING"));
	if (PlayerPawn(Owner) != None)
		PacketLoss = int(PlayerPawn(Owner).ConsoleCommand("GETLOSS"));
		
}

defaultproperties
{
Rank="Newbie"
XP=0
Money=0
NumFragged=0
MaxSpree=0
WeaponString=""
InventoryString=""
TimePlayed=0
MaxHealth=100
bShopping=False
bHasTornado=False
bHasShield=False
bHasDoubleDamage=False
bHasHealthRegrow=False
bHasRadar=False
bRadarMutatedOff=False
NumItems=0
RespawnablesID="N/A"
Viewing="home"
ViewItem=0
bSynced=False
bStarted=False
bAddedToTempDB=False
bJumpBoots=True
MenuCountdown=99
}
